'use strict'

entityRegistry['module']['glitchCopy'] = {
    extendedInfo: {
        displayName: 'Glitch Copy',
        displayGroup: 'Post Processing',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'bingo' },
        { paramName: 'blockCount', displayName: 'Block Count', type: 'string', defaultValue: '4', uiOptions: { options: [{text:'2',value:'2'}, {text:'4',value:'4'}, {text:'8',value:'8'}, {text:'16',value:'16'}, {text:'32',value:'32'}]}},
        { paramName: 'maxBlocksWide', displayName: 'Max Blocks Wide', type: 'int', defaultValue: 4, uiOptions: { min: 1 } },
        { paramName: 'colorMode', displayName: 'Color Mode', type: 'string', defaultValue: 'leave', uiOptions: { options: [{text:'Leave',value:'leave'}, {text:'Local',value:'local'}, {text:'Global',value:'global'}]}},
        { paramName: 'brightnessMode', displayName: 'Brightness Mode', type: 'string', defaultValue: 'leave', uiOptions: { options: [{text:'Leave',value:'leave'}, {text:'Local',value:'local'}, {text:'Global',value:'global'}]}},
        { paramName: 'depthMode', displayName: 'Depth Mode', type: 'string', defaultValue: 'leave', uiOptions: { options: [{text:'Leave',value:'leave'}, {text:'Local',value:'local'}, {text:'Global',value:'global'}]}},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                seed,
                blockCount,
                maxBlocksWide,
                colorMode,
                brightnessMode,
                depthMode,
            } = { ...config }

            const depthBuffer = renderer.getCurrentBuffer('depth')
            const bufferWidth = depthBuffer.width
            const bufferHeight = depthBuffer.height

            const totalBlocks = parseInt(blockCount)
            const stride = bufferWidth

            const makeBlocks = (seed) => {
                const rng = new Math.seedrandom(seed)
                const blockWidth = bufferWidth / totalBlocks
                const blocks = []
                for (let i = 0; i < totalBlocks; ) {
                    let thisBlockWidth = Math.round(rng() * maxBlocksWide)
                    thisBlockWidth = Math.min(totalBlocks - i, thisBlockWidth)
                    const thisBlockPixelWidth = thisBlockWidth * blockWidth
                    const newBlock = {
                        srcX: Math.floor(rng() * (bufferWidth-thisBlockPixelWidth)),
                        dstX: i * blockWidth,
                        width: thisBlockPixelWidth,
                        reverse: rng() >= 0.5,
                    }
                    blocks.push(newBlock)
                    i += thisBlockWidth
                }
                return blocks
            }
            const globalBlocks = makeBlocks(seed)

            const glitchBuffer = (bufferName, mode, seed) => {
                if (mode !== 'leave') {
                    const srcBufferId = renderer.getCurrentBufferId(bufferName)
                    const dstBufferId = renderer.lockBuffer(bufferName)
                    const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId).data
                    const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId).data

                    const blocks = mode === 'global' ? globalBlocks : makeBlocks(seed)
                    blocks.forEach(block => {
                        const { srcX, dstX, width, reverse } = {...block}
                        for (let y = 0; y < bufferHeight; ++y) {
                            let dstIndex = y*stride + dstX
                            for (let x = 0; x < width; ++x) {
                                const srcIndex = reverse ? 
                                    y*stride + srcX+width-x :
                                    y*stride + srcX+x
                                dstBuffer[dstIndex++] = srcBuffer[srcIndex]
                            }
                        }
                    })

                    renderer.unlockBuffer(bufferName, srcBufferId)
                    renderer.setCurrentBufferId(bufferName, dstBufferId)
                }
            }
            glitchBuffer('color', colorMode, seed + '1')
            glitchBuffer('brightness', brightnessMode, seed + '2')
            glitchBuffer('depth', depthMode, seed + '3')
        }
    }
}
